/****** Object:  StoredProcedure [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_DEPOSITO]    Script Date: 11/25/2013 11:36:44 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_DEPOSITO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_DEPOSITO]
GO
GO
GO
GO
--EXECUTE P_ANALISE_VENDA_PRODUTOS_DIARIA_DEPOSITO  1,1,NULL,1  
CREATE PROCEDURE [dbo].[P_ANALISE_VENDA_PRODUTOS_DIARIA_DEPOSITO] @CD_EMP   INT=1,   
                 @QT_MESES  INT=1,   
                 @DT_ATUAL  DATETIME=NULL,  
                 @CD_CTR_DEPO INT =1  
AS  
DECLARE   
  @CD_FILIAL INT,   
  @DT_BASE DATETIME,   
  @ANO_INI INT,   
  @MES_INI INT,   
  @ANO_FIM INT,   
  @MES_FIM INT,   
  @INI  INT,   
  @FIM  INT,  
  @DT_INI_MES DATETIME,   
  @DT_FIM_MES DATETIME;  
  
SET @CD_FILIAL = (SELECT CD_FILIAL FROM PRC_FILIAL_DEPOSITO  WHERE CD_EMP=@CD_EMP AND CD_CTR_DEPO=@CD_CTR_DEPO);  
  
DECLARE @FLAGCONTROLETIPOCOMPRAFILIAL INT  
  
SET @FLAGCONTROLETIPOCOMPRAFILIAL=ISNULL((SELECT   
            VALOR AS ORC_PED_CP  
             FROM   
             PRC_EMP_CONFIG  
             WHERE   
             CD_EMP = @CD_EMP   
             AND CD_CHAVE = 'FLAG_CONTROLE_TIPO_COMPRA_FILIAL'),0);  
             
CREATE TABLE #ANALISE (CD_EMP     INT,  
		CD_FILIAL   INT,  
		DT_VD    DATETIME,  
		CD_PROD    INT,  
		PART_QTDE   MONEY,  
		QT_VD_DIA   MONEY,  
		QT_MEDIA_VD   MONEY,  
		PART_VLR   MONEY,  
		VLR_MEDIO_VD  MONEY,  
		COBERTURA   MONEY,  
		QT_EST    MONEY,  
		QT_EXCESSO   MONEY,  
		LIMITE_EXCESSO  MONEY,  
		FLAG_PART_INDIC  MONEY,  
		QT_EST_EM_TERC  MONEY,   
		QT_EST_DE_TERC  MONEY,   
		QT_EST_DEPOSITOS MONEY,  
		MEDIAF    MONEY,  
		QT_PEND_ENT   MONEY,  
		QT_PEND_SAI   MONEY,  
		QT_RESSUP_DIA  MONEY,  
		QT_CP_DIA   MONEY,  
		CD_SIGLA   INT,  
		VLR_DESC_VD   MONEY,  
		QT_DIAS_EXCESSO  MONEY,  
		QT_RESSUP_PROX_DIA MONEY,  
		CD_FABRIC    INT,  
		CD_ARV_MERC_LINHA  INT,  
		COMPRA_POR_SUPRIMENTO INT,  
		LJ_FLAG_PARTIC_INDIC INT,  
		FLAG_ANALISE_FALTAS  INT,  
		STS_PROD_EMP   INT,  
		STS_PROD_FILIAL   INT,  
		EMAX     MONEY,  
		ESEG     MONEY,  
		QTDE_FACEAMENTO MONEY,  
		QTDE_FINANCIADO MONEY,  
		QTDE_LIMITADOR  MONEY, 
		VLR_CUSTO		MONEY,
		VLR_CUSTO_MD	MONEY,
		VLR_TABELA		MONEY,
		VLR_OFERTA		MONEY);
  
CREATE TABLE #EXCESSO (CD_EMP     INT,   
						CD_FILIAL    INT,   
						DT_ATUAL    DATETIME,   
						CD_PROD     INT,   
						CURVA     VARCHAR(5),   
						MEDIAF     MONEY,   
						COBERTURA    MONEY,  
						QT_EST     MONEY,   
						QTDE_EXCESSO   MONEY,  
						EMAX      MONEY,  
						QT_EST_EM_TERC   MONEY,   
						QT_EST_DE_TERC   MONEY,   
						QT_EST_DEPOSITOS  MONEY,  
						QTDE_MEDIAF    MONEY,  
						QT_PEND_ENT    MONEY,  
						QT_PEND_SAI    MONEY,   
						QT_DIAS_EXCESSO   MONEY );  
  
  
--Calculo do periodo de analise  
  
 PRINT 'Inicio da rotina - Hora : ' + convert(varchar,getdate(),108) ;  
   
 IF @DT_ATUAL IS NULL SELECT @DT_ATUAL=dbo.F_ONTEM();  
 SELECT 
	@DT_BASE	= DATEADD(mm, -1, @DT_ATUAL + 1),  
	@ANO_FIM	= YEAR(@DT_BASE),   
	@MES_FIM	= MONTH(@DT_BASE),   
	@ANO_INI	= @ANO_FIM,     
	@MES_INI	= @MES_FIM-@QT_MESES+1;  
  
 WHILE @MES_INI<=0   
  SELECT @MES_INI=@MES_INI+12,   
    @ANO_INI=@ANO_INI-1;  
  
 SELECT   
  @INI=(@ANO_INI*100)+@MES_INI,   
  @FIM=(@ANO_FIM*100)+@MES_FIM;  
  
PRINT '== ANALISE DIARIA DEPOSITO  =='   
PRINT @CD_FILIAL  
PRINT 'Processa movimentos dia ' + convert(char(20),@DT_ATUAL,103) + ' - Hora : ' + convert(varchar,getdate(),108) ;  
  
--Limpa eventual dado previo do dia  
	DELETE   
	FROM   
		EST_PROD_CPL_ANALISE_DIARIO   
	WHERE   
		CD_FILIAL = @CD_FILIAL  
		AND DT_VD = @DT_ATUAL   
		AND CD_EMP= @CD_EMP;  
  
  
PRINT 'Removidos registros previos - ' + CONVERT(CHAR(16), GETDATE(), 114);  --removidos 4 caracteres milissegundos  
 
--Processando faltas  
  
;WITH a AS (   ---analise meses passados  
			SELECT   
				CD_PROD,   
				PART_QTDE   = SUM(PART_QTDE) / @QT_MESES,  
				QT_MEDIA_VD = SUM(QTDE_TOTAL)/ @QT_MESES,  
				PART_VLR    = SUM(PART_VLR)  / @QT_MESES  
			FROM   
				EST_PROD_CPL_ANALISE  
			WHERE   
				CD_EMP=@CD_EMP   
				AND CD_FILIAL=@CD_FILIAL   
				AND ANO*100+MES BETWEEN @INI AND @FIM  
			GROUP BY CD_PROD),  
 ----vendas do dia  
 v AS (  SELECT   
			CD_PROD,   
			QTDE_IT      = SUM(I.QT_IT),  
			VLR_TOTAL_VD = SUM(I.TOT_IT),  
			VLR_DESC_VD  = SUM((ROUND(COALESCE(I.VLR_DESC, I.QT_IT * I.VLR_IT * I.TX_DESC / 100), 2)) + (CASE WHEN ISNULL(I.VLR_PMC,0) > I.VLR_IT THEN  (I.VLR_PMC - I.VLR_IT) * I.QT_IT ELSE 0 END ))  
		FROM   
			PDV_VD_IT I  
			INNER JOIN PRC_FILIAL_DEPOSITO_PRC_FILIAL F ON   
			I.CD_EMP    =F.CD_EMP AND   
			I.CD_FILIAL =F.CD_FILIAL  
		WHERE   
			I.CD_EMP=@CD_EMP   
			AND I.DT_VD=@DT_ATUAL  
			AND F.CD_CTR_DEPO =@CD_CTR_DEPO  
			and ST_IT=1
		GROUP BY I.CD_PROD)  
  
  
INSERT INTO #ANALISE   
(CD_EMP,   
	CD_FILIAL,   
	DT_VD,   
	CD_PROD,   
	PART_QTDE,   
	QT_VD_DIA,   
	QT_MEDIA_VD,   
	PART_VLR,   
	VLR_MEDIO_VD,   
	COBERTURA,   
	QT_EST,   
	QT_EXCESSO,   
	LIMITE_EXCESSO,  
	FLAG_PART_INDIC,  
	QT_EST_EM_TERC,   
	QT_EST_DE_TERC,   
	QT_EST_DEPOSITOS,  
	MEDIAF,  
	QT_PEND_ENT,  
	QT_PEND_SAI,  
	QT_RESSUP_DIA,  
	QT_CP_DIA,  
	CD_SIGLA,  
	VLR_DESC_VD,   
	QT_DIAS_EXCESSO,  
	QT_RESSUP_PROX_DIA,  
	CD_FABRIC,  
	CD_ARV_MERC_LINHA,  
	COMPRA_POR_SUPRIMENTO,  
	LJ_FLAG_PARTIC_INDIC,  
	FLAG_ANALISE_FALTAS,  
	STS_PROD_EMP,  
	STS_PROD_FILIAL,  
	EMAX,  
	ESEG,  
	QTDE_FACEAMENTO,  
	QTDE_FINANCIADO,  
	QTDE_LIMITADOR,
	VLR_CUSTO,
	VLR_CUSTO_MD,
	VLR_TABELA,
	VLR_OFERTA)  
  
 SELECT   
	CD_EMP          = @CD_EMP,  
	CD_FILIAL       = @CD_FILIAL,   
	DT_VD           = @DT_ATUAL,   
	CD_PROD         = ISNULL(a.CD_PROD, v.CD_PROD),  
	PART_QTDE       = ISNULL(a.PART_QTDE, 0),   
	QTDE_IT         = ISNULL(v.QTDE_IT, 0),  
	QT_MEDIA_VD     = ISNULL(a.QT_MEDIA_VD, 0),   
	PART_VLR        = ISNULL(a.PART_VLR, 0),   
	VLR_TOTAL_VD    = ISNULL(v.VLR_TOTAL_VD, 0),  
	COBERTURA       = 0,   
	QT_EST          = 0,   
	QT_EXCESSO      = 0,   
	LIMITE_EXCESSO  = 0,  
	FLAG_PART_INDIC = 0,  
	QT_EST_EM_TERC = 0,   
	QT_EST_DE_TERC = 0,   
	QT_EST_DEPOSITOS= 0,  
	MEDIAF   = 0,  
	QT_PEND_ENT  = 0,  
	QT_PEND_SAI  = 0,  
	QT_RESSUP_DIA = 0,  
	QT_CP_DIA  = 0,  
	CD_SIGLA  = 0,  
	VLR_DESC_VD  = ISNULL(VLR_DESC_VD,0),  
	QT_DIAS_EXCESSO = 0,  
	QT_RESSUP_PROX_DIA=0,  
	CD_FABRIC    =0,  
	CD_ARV_MERC_LINHA  =0,  
	COMPRA_POR_SUPRIMENTO =0,  
	LJ_FLAG_PARTIC_INDIC =0,  
	FLAG_ANALISE_FALTAS  =0,  
	STS_PROD_EMP   =0,  
	STS_PROD_FILIAL   =0,  
	EMAX     =0,  
	ESEG     =0,  
	QTDE_FACEAMENTO   =0,  
	QTDE_FINANCIADO   =0,  
	QTDE_LIMITADOR   =0 ,
	VLR_CUSTO				=NULL,
	VLR_CUSTO_MD			=NULL,
	VLR_TABELA				=NULL,
	VLR_OFERTA				=NULL

 FROM a  FULL OUTER JOIN v ON a.CD_PROD=v.CD_PROD;  
  
PRINT 'Inseridos novos registros - ' + CONVERT(CHAR(16), GETDATE(), 114);  --removidos 4 caracteres milissegundos  
  
--Registra se o produto participa dos indicadores  
UPDATE a SET   
	a.FLAG_PART_INDIC = p.FLAG_ANALISE_EXC_COB,  
	a.QT_EST   = c.QT_EST,  
	a.QT_EST_EM_TERC = c.QT_EST_EM_TERC,   
	a.QT_EST_DE_TERC = c.QT_EST_DE_TERC,   
	a.QT_EST_DEPOSITOS = c.QT_EST_DEPOSITOS,  
	a.MEDIAF   = c.MEDIAF,  
	a.QT_PEND_ENT  = ISNULL(c.QT_PEND_ENT,0),  
	a.QT_PEND_SAI  = ISNULL(c.QT_PEND_SAI,0),  
	a.QT_RESSUP_DIA  = 0,  
	a.QT_CP_DIA   = 0,  
	a.CD_SIGLA   = c.CD_SIGLA,  
	A.CD_FABRIC    =p.CD_FABRIC,  
	A.CD_ARV_MERC_LINHA  =arv.CD_ARV_MERC_LINHA,  
	A.COMPRA_POR_SUPRIMENTO =CASE WHEN @FLAGCONTROLETIPOCOMPRAFILIAL = 0 THEN ISNULL(P.COMPRA_POR_SUPRIMENTO,0) ELSE ISNULL(C.COMPRA_POR_SUPRIMENTO,0) END,  
	A.LJ_FLAG_PARTIC_INDIC =CASE WHEN F.FLAG_NAO_PARTIC_INDIC = 0 THEN 1 ELSE 0 END,  
	A.FLAG_ANALISE_FALTAS =P.FLAG_ANALISE_FALTAS,  
	A.STS_PROD_EMP   =p.STS_PROD,  
	A.STS_PROD_FILIAL  =C.STS_PROD_FILIAL,  
	A.EMAX     =c.EMAX,  
	A.ESEG     =c.ESEG,  
	A.QTDE_FACEAMENTO  =C.QTDE_FACEAMENTO,  
	A.QTDE_FINANCIADO  =C.QTDE_FINANCIADO,  
	A.QTDE_LIMITADOR  =C.QTDE_LIMITADOR ,
	A.VLR_CUSTO				=C.VLR_CUSTO,
	A.VLR_CUSTO_MD			=C.VLR_CUSTO_MD,
	A.VLR_TABELA			=vlr.VLR_TABELA,
	A.VLR_OFERTA			=vlr.VLR_OFERTA  
FROM   
	#ANALISE a   
	INNER JOIN EST_PROD p ON  
	a.CD_EMP = p.CD_EMP AND   
	a.CD_PROD = p.CD_PROD   
	INNER JOIN V_EST_PROD_CPL_ESTOQUE  c ON  
	a.CD_EMP  = c.CD_EMP AND   
	a.CD_FILIAL  = c.CD_FILIAL AND  
	a.CD_PROD  = c.CD_PROD     
	INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA arv ON  
	a.CD_EMP = arv.CD_EMP AND   
	a.CD_PROD = arv.CD_PROD  
	 
	INNER JOIN  EST_PROD_PRECO vlr ON
	a.CD_EMP		= vlr.CD_EMP AND 
	a.CD_FILIAL		= vlr.CD_FILIAL AND
	a.CD_PROD		= vlr.CD_PROD   

	INNER JOIN PRC_FILIAL f ON  
	a.CD_EMP  = f.CD_EMP AND   
	a.CD_FILIAL  = f.CD_FILIAL   
WHERE   
	a.DT_VD   =@DT_ATUAL   
	AND a.CD_EMP =@CD_EMP  
	AND a.CD_FILIAL =@CD_FILIAL;  
  
PRINT 'Obtido estoque e flag indicadores - ' + CONVERT(CHAR(16), GETDATE(), 114);  --removidos 4 caracteres milissegundos  
  
/* ----------------------------------------------------------------------------------------------------------------------------------------*/  
/* ----------------------------------------------------------------------------------------------------------------------------------------*/  
  
UPDATE a SET   
 QT_RESSUP_DIA = res.QT_RESSUP  
FROM   
	#ANALISE a   
	INNER JOIN (SELECT   
					CD_EMP,  
					CD_PROD,  
					CD_FIL_DEST CD_FILIAL,  
					SUM (QT_AT) QT_RESSUP  
					FROM   
					V_EST_PROD_TRANSF_IT   
					WHERE   
					DT_TRANSF = @DT_ATUAL  
					AND CD_EMP= @CD_EMP   
					AND CD_FIL_DEST = @CD_FILIAL  
					GROUP BY   
					CD_EMP,   
					CD_PROD,  
					CD_FIL_DEST) res ON   
	a.CD_EMP  = res.CD_EMP AND   
	a.CD_FILIAL  = res.CD_FILIAL AND  
	a.CD_PROD  = res.CD_PROD   
  
WHERE   
	a.DT_VD   =@DT_ATUAL   
	AND a.CD_EMP =@CD_EMP  
	AND a.CD_FILIAL =@CD_FILIAL;  
  
  
PRINT 'Registrou quantidade de itens ressuprimento do dia - ' + CONVERT(CHAR(16), GETDATE(), 114);   
/* ----------------------------------------------------------------------------------------------------------------------------------------*/  
/* ----------------------------------------------------------------------------------------------------------------------------------------*/  
  
UPDATE a SET   
	QT_CP_DIA = cp.QT_CP  
FROM   
	#ANALISE a   
	INNER JOIN (SELECT       
					EST_PED_CP.CD_EMP,   
					EST_PED_CP.CD_FILIAL,   
					IT.CD_PROD,  
					SUM(IT.QT_IT) QT_CP  
				FROM      
					EST_PED_CP  EST_PED_CP   
					INNER JOIN EST_PED_CP_IT IT ON  
					EST_PED_CP.CD_EMP  = IT.CD_EMP AND  
					EST_PED_CP.CD_FILIAL = IT.CD_FILIAL AND  
					EST_PED_CP.CD_PED  = IT.CD_PED   
				WHERE     
					EST_PED_CP.STS_PED <> 2  
					AND EST_PED_CP.CD_EMP  = @CD_EMP  
					AND EST_PED_CP.CD_FILIAL = @CD_FILIAL  
					AND EST_PED_CP.DT_EMI  = @DT_ATUAL  
				GROUP BY   
					EST_PED_CP.CD_EMP,   
					EST_PED_CP.CD_FILIAL,   
					IT.CD_PROD)  cp ON   
		a.CD_EMP  = cp.CD_EMP AND   
		a.CD_FILIAL  = cp.CD_FILIAL AND  
		a.CD_PROD  = cp.CD_PROD   
	WHERE   
		a.DT_VD   =@DT_ATUAL   
		AND a.CD_EMP =@CD_EMP  
		AND a.CD_FILIAL =@CD_FILIAL;  
  
  
PRINT 'Registrou quantidade de itens compra do dia - ' + CONVERT(CHAR(16), GETDATE(), 114);   
  
  
/* ----------------------------------------------------------------------------------------------------------------------------------------*/  
/* ----------------------------------------------------------------------------------------------------------------------------------------*/  
  
  
 --Gerando Excesso  
 INSERT INTO #EXCESSO  
	SELECT   
	@CD_EMP AS CD_EMP,   
	c.CD_FILIAL,   
	@DT_ATUAL AS DT_ATUAL,   
	c.CD_PROD,   
	s.DS_SIGLA AS CURVA,   
	c.MEDIAF AS QT_MEDIA,   
	ROUND(CASE WHEN c.MEDIAF > 0 THEN   
	((isnull(c.QT_EST ,0)+ isnull(c.QT_EST_EM_TERC,0) + isnull(c.QT_EST_DEPOSITOS,0)) / (c.MEDIAF)) * 30  
	ELSE   
	CONVERT(FLOAT, ((isnull(c.QT_EST ,0)+ isnull(c.QT_EST_EM_TERC,0) + isnull(c.QT_EST_DEPOSITOS,0)) / 0.001))  
	END, 2 )  AS COBERTURA,  
	c.QT_EST QT_EST,   
	0 AS QTDE_EXCESSO,  
	CASE WHEN F.PARAM_EST =0 THEN 15   
		ELSE ISNULL(F.PARAM_EST,15) END LIMITE_EXCESSO,  
	c.QT_EST_EM_TERC ,   
	c.QT_EST_DE_TERC ,   
	c.QT_EST_DEPOSITOS ,  
	c.MEDIAF,  
	0 QT_PEND_ENT,     
	0 QT_PEND_SAI,  
	0 QT_DIAS_EXCESSO  
 FROM    
	V_EST_PROD_CPL_ESTOQUE c   
	INNER JOIN EST_PROD p ON   
	c.CD_EMP = p.CD_EMP AND   
	c.CD_PROD= p.CD_PROD  

	INNER JOIN EST_PROD_FABRIC f ON   
	p.CD_FABRIC= f.CD_FABRIC  

	INNER JOIN EST_PROD_CURVA_SIGLA s ON   
	c.CD_EMP = s.CD_EMP AND   
	c.CD_SIGLA = s.CD_SIGLA         
 WHERE   
	c.CD_EMP  =@CD_EMP   
	AND c.CD_FILIAL = @CD_FILIAL;  
   
 UPDATE   
  a   
 SET   
	COBERTURA  =e.COBERTURA,   
	QT_EST   =e.QT_EST,   
	LIMITE_EXCESSO =e.EMAX,   
	QT_MEDIA_VD  =e.MEDIAF,  
	QT_EXCESSO     = CASE WHEN e.MEDIAF = 0 AND  (ISNULL(e.QT_EST,0) + ISNULL(e.QT_EST_EM_TERC,0) + ISNULL(e.QT_EST_DEPOSITOS,0)) > 0 THEN   
					(ISNULL(e.QT_EST,0) + ISNULL(e.QT_EST_EM_TERC,0) + ISNULL(e.QT_EST_DEPOSITOS,0))       
					WHEN (ISNULL(e.QT_EST,0) + ISNULL(e.QT_EST_EM_TERC,0) + ISNULL(e.QT_EST_DEPOSITOS,0)) > ((e.MEDIAF/30.0000) *  e.EMAX) THEN   
					ROUND((ISNULL(e.QT_EST,0) + ISNULL(e.QT_EST_EM_TERC,0) + ISNULL(e.QT_EST_DEPOSITOS,0))  - ((e.MEDIAF/30.0000) *  e.EMAX),0)   
					ELSE   
					0   
					END,   
  
  QT_DIAS_EXCESSO = CASE WHEN e.MEDIAF = 0 AND (ISNULL(e.QT_EST,0) + ISNULL(e.QT_EST_EM_TERC,0) + ISNULL(e.QT_EST_DEPOSITOS,0)) > 0 THEN   
					120    
					WHEN e.COBERTURA > e.EMAX THEN   
						ROUND((e.COBERTURA-e.EMAX) ,0)   
					ELSE  0  END  
 FROM   
	#EXCESSO e   
	INNER JOIN #ANALISE a ON   
	e.CD_EMP=a.CD_EMP AND   
	e.CD_FILIAL=a.CD_FILIAL AND   
	e.CD_PROD=a.CD_PROD AND   
	e.DT_ATUAL=a.DT_VD;  


PRINT 'Gerado excesso e cobertura - ' + CONVERT(CHAR(16), GETDATE(), 114);  --removidos 4 caracteres milissegundos  
  
  INSERT INTO  EST_PROD_CPL_ANALISE_DIARIO (CD_EMP,CD_FILIAL,DT_VD,CD_PROD,PART_QTDE,QT_VD_DIA,QT_MEDIA_VD,PART_VLR,
											VLR_MEDIO_VD,COBERTURA,QT_EST,QT_EXCESSO,LIMITE_EXCESSO,FLAG_PART_INDIC,
											QT_EST_EM_TERC,QT_EST_DE_TERC,QT_EST_DEPOSITOS,MEDIAF,QT_PEND_ENT,QT_PEND_SAI,
											QT_RESSUP_DIA,QT_CP_DIA,CD_SIGLA,VLR_DESC_VD,QT_DIAS_EXCESSO,QT_RESSUP_PROX_DIA,
											CD_FABRIC,CD_ARV_MERC_LINHA,COMPRA_POR_SUPRIMENTO,LJ_FLAG_PARTIC_INDIC,FLAG_ANALISE_FALTAS,STS_PROD_EMP,
											STS_PROD_FILIAL,EMAX,ESEG,QTDE_FACEAMENTO,QTDE_FINANCIADO,QTDE_LIMITADOR,DT_CAD,
											VLR_CUSTO,VLR_CUSTO_MD,VLR_TABELA,VLR_OFERTA) 
  SELECT   
	CD_EMP,   
	CD_FILIAL,   
	DT_VD,   
	CD_PROD,   
	PART_QTDE,   
	QT_VD_DIA,   
	QT_MEDIA_VD,   
	PART_VLR,   
	VLR_MEDIO_VD,   
	isnull(COBERTURA,0),   
	QT_EST,   
	QT_EXCESSO,   
	LIMITE_EXCESSO,  
	FLAG_PART_INDIC,  
	QT_EST_EM_TERC ,   
	QT_EST_DE_TERC ,   
	QT_EST_DEPOSITOS ,  
	MEDIAF,  
	QT_PEND_ENT,  
	QT_PEND_SAI,  
	QT_RESSUP_DIA,  
	QT_CP_DIA,  
	CD_SIGLA,  
	VLR_DESC_VD,  
	QT_DIAS_EXCESSO,  
	QT_RESSUP_PROX_DIA,  
	CD_FABRIC,  
	CD_ARV_MERC_LINHA,  
	COMPRA_POR_SUPRIMENTO,  
	LJ_FLAG_PARTIC_INDIC,  
	FLAG_ANALISE_FALTAS,  
	STS_PROD_EMP,  
	STS_PROD_FILIAL,  
	EMAX,  
	ESEG,  
	QTDE_FACEAMENTO,  
	QTDE_FINANCIADO,  
	QTDE_LIMITADOR,
	GETDATE () DT_CAD ,
	ISNULL(VLR_CUSTO,0),
	ISNULL(VLR_CUSTO_MD,0),
	ISNULL(VLR_TABELA,0),
	ISNULL(VLR_OFERTA,0)
  FROM   
	#ANALISE  
  WHERE  
	DT_VD=@DT_ATUAL   
	AND CD_EMP=@CD_EMP  
	AND CD_FILIAL=@CD_FILIAL;  
  
PRINT 'Registros na tabela de analise - ' + CONVERT(CHAR(16), GETDATE(), 114);  --removidos 4 caracteres milissegundos  
  
SELECT   
  @DT_INI_MES=CONVERT(CHAR(4), @ANO_FIM) + RIGHT('0' + CONVERT(VARCHAR(2), @MES_FIM), 2) + '01',  
  @DT_FIM_MES=DATEADD(MONTH, 1, @DT_INI_MES);  
   
WITH BASE AS (SELECT   
				CD_FILIAL,   
				CD_PROD,   
				COUNT(DT_VD) QT_DIAS_CALCULO,   
				SUM(CASE WHEN QT_EST=0 THEN 1 ELSE 0 END) QT_DIAS_FALTA  
			FROM   
				EST_PROD_CPL_ANALISE_DIARIO   
			WHERE   
				CD_EMP=@CD_EMP   
				AND DT_VD BETWEEN @DT_INI_MES  AND @DT_FIM_MES  
				AND CD_FILIAL =@CD_FILIAL  
			GROUP BY   
				CD_FILIAL,   
				CD_PROD)   
	UPDATE   
		m   
	SET   
		QT_DIAS_FALTA=ISNULL(d.QT_DIAS_FALTA,0),   
		QT_DIAS_CALCULO=ISNULL(d.QT_DIAS_CALCULO,0),  
		DT_CALCULO_DIARIO=GETDATE()  
	FROM   
		EST_PROD_CPL_ANALISE m   
		INNER JOIN BASE d ON   
		d.CD_FILIAL = m.CD_FILIAL AND   
		d.CD_PROD = m.CD_PROD   
	WHERE   
		m.CD_EMP=@CD_EMP   
		AND m.CD_FILIAL=@CD_FILIAL  
		AND m.ANO=@ANO_FIM   
		AND m.MES=@MES_FIM;  
  
PRINT 'Consolidei dias em falta na analise mensal - ' + CONVERT(CHAR(16), GETDATE(), 114);  --removidos 4 caracteres milissegundos  

GO


